/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import javax.annotation.Nonnull;
import mekanism.common.block.interfaces.IPersonalStorage;
import mekanism.common.inventory.container.item.PersonalStorageItemContainer;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.util.SecurityUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;

public class ItemBlockPersonalStorage<BLOCK extends Block & IPersonalStorage>
extends ItemBlockTooltip<BLOCK>
implements IItemSustainedInventory,
IGuiItem {
    private final ResourceLocation openStat;

    public ItemBlockPersonalStorage(BLOCK block, ResourceLocation openStat) {
        super(block);
        this.openStat = openStat;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        return SecurityUtils.INSTANCE.claimOrOpenGui(world, player, hand, (p, h, s) -> {
            this.getContainerType().tryOpenGui((ServerPlayer)p, (InteractionHand)h, (ItemStack)s);
            p.m_36246_(Stats.f_12988_.m_12902_((Object)this.openStat));
        });
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        InteractionResult result = this.m_40576_(new BlockPlaceContext(context));
        Player player = context.m_43723_();
        return result.m_19077_() || player == null ? result : this.m_7203_(context.m_43725_(), player, context.m_43724_()).m_19089_();
    }

    protected boolean m_40610_(@Nonnull BlockPlaceContext context, @Nonnull BlockState state) {
        Player player = context.m_43723_();
        return (player == null || player instanceof FakePlayer || player.m_6144_()) && super.m_40610_(context, state);
    }

    public ContainerTypeRegistryObject<PersonalStorageItemContainer> getContainerType() {
        return MekanismContainerTypes.PERSONAL_STORAGE_ITEM;
    }
}

